using System;
using System.IO;

public class Program
{
  public static void Main(String[] args)
  {
    if(args.Length < 2)
    {
      Console.WriteLine("Wywoanie programu: Program plik ile_wartoci");
      return;
    }

    String plik = args[0];

    int ile;
    try
    {
      ile = Int32.Parse(args[1]);
    }
    catch(Exception)
    {
      Console.WriteLine("{0} nie jest prawidow wartoci cakowit.", args[1]);
      return;
    }

    byte[] dane = new byte[ile];
    for(int i = 0; i < ile; i++)
    {
      if(i % 2 == 0)
        dane[i] = 127;
      else
        dane[i] = 255;
    }

    FileStream fs;
    try
    {
      fs = new FileStream(plik, FileMode.Create);
    }
    catch(Exception)
    {
      Console.WriteLine("Otwarcie pliku {0} nie powiodo si.", plik);
      return;
    }

    try
    {
      fs.Write(dane, 0, ile);
    }
    catch(Exception)
    {
      Console.WriteLine("Zapis nie zosta dokonany.");
      return;
    }
    Console.WriteLine("Zapis zosta dokonany.");
  }
}
